/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.definitions;

import appeng.api.ids.AEBlockIds;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseBlockItem;
import appeng.block.AEBaseBlockItemChargeable;
import appeng.block.crafting.CraftingBlockItem;
import appeng.block.crafting.CraftingMonitorBlock;
import appeng.block.crafting.CraftingUnitBlock;
import appeng.block.crafting.CraftingUnitType;
import appeng.block.crafting.MolecularAssemblerBlock;
import appeng.block.crafting.PatternProviderBlock;
import appeng.block.misc.CellWorkbenchBlock;
import appeng.block.misc.ChargerBlock;
import appeng.block.misc.CondenserBlock;
import appeng.block.misc.InscriberBlock;
import appeng.block.misc.InterfaceBlock;
import appeng.block.misc.LightDetectorBlock;
import appeng.block.misc.QuartzFixtureBlock;
import appeng.block.misc.QuartzGrowthAcceleratorBlock;
import appeng.block.misc.SecurityStationBlock;
import appeng.block.misc.SkyCompassBlock;
import appeng.block.misc.TinyTNTBlock;
import appeng.block.misc.VibrationChamberBlock;
import appeng.block.networking.CableBusBlock;
import appeng.block.networking.ControllerBlock;
import appeng.block.networking.CreativeEnergyCellBlock;
import appeng.block.networking.DenseEnergyCellBlock;
import appeng.block.networking.EnergyAcceptorBlock;
import appeng.block.networking.EnergyCellBlock;
import appeng.block.networking.WirelessBlock;
import appeng.block.paint.PaintSplotchesBlock;
import appeng.block.qnb.QuantumLinkChamberBlock;
import appeng.block.qnb.QuantumRingBlock;
import appeng.block.spatial.MatrixFrameBlock;
import appeng.block.spatial.SpatialAnchorBlock;
import appeng.block.spatial.SpatialIOPortBlock;
import appeng.block.spatial.SpatialPylonBlock;
import appeng.block.storage.ChestBlock;
import appeng.block.storage.DriveBlock;
import appeng.block.storage.IOPortBlock;
import appeng.block.storage.SkyChestBlock;
import appeng.block.storage.SkyStoneTankBlock;
import appeng.core.AppEng;
import appeng.core.CreativeTab;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.BlockDefinition;
import appeng.debug.ChunkLoaderBlock;
import appeng.debug.CubeGeneratorBlock;
import appeng.debug.EnergyGeneratorBlock;
import appeng.debug.ItemGenBlock;
import appeng.debug.PhantomNodeBlock;
import appeng.decorative.AEDecorativeBlock;
import appeng.decorative.solid.QuartzGlassBlock;
import appeng.decorative.solid.QuartzLampBlock;
import appeng.decorative.solid.QuartzOreBlock;
import appeng.decorative.solid.QuartzPillarBlock;
import appeng.decorative.solid.SkyStoneBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;

public final class AEBlocks {
    private static final List<BlockDefinition<?>> BLOCKS = new ArrayList();
    private static final BlockBehaviour.Properties QUARTZ_PROPERTIES = AEBaseBlock.defaultProps(Material.f_76278_).m_60913_(3.0f, 5.0f).m_60999_();
    private static final BlockBehaviour.Properties SKYSTONE_PROPERTIES = AEBaseBlock.defaultProps(Material.f_76278_).m_60913_(5.0f, 150.0f).m_60999_();
    private static final BlockBehaviour.StateArgumentPredicate<EntityType<?>> NEVER_ALLOW_SPAWN = (p1, p2, p3, p4) -> false;
    private static final BlockBehaviour.Properties SKY_STONE_CHEST_PROPS = AEBaseBlock.defaultProps(Material.f_76278_).m_60913_(5.0f, 150.0f).m_60955_();
    public static final BlockDefinition<QuartzOreBlock> QUARTZ_ORE = AEBlocks.block("Certus Quartz Ore", AEBlockIds.QUARTZ_ORE, () -> new QuartzOreBlock(QUARTZ_PROPERTIES));
    public static final BlockDefinition<QuartzOreBlock> DEEPSLATE_QUARTZ_ORE = AEBlocks.block("Deepslate Certus Quartz Ore", AEBlockIds.DEEPSLATE_QUARTZ_ORE, () -> new QuartzOreBlock(QUARTZ_PROPERTIES.m_60913_(4.5f, 5.0f).m_60918_(SoundType.f_154677_)));
    public static final BlockDefinition<MatrixFrameBlock> MATRIX_FRAME = AEBlocks.block("Matrix Frame", AEBlockIds.MATRIX_FRAME, MatrixFrameBlock::new);
    public static final BlockDefinition<AEDecorativeBlock> QUARTZ_BLOCK = AEBlocks.block("Certus Quartz Block", AEBlockIds.QUARTZ_BLOCK, () -> new AEDecorativeBlock(QUARTZ_PROPERTIES));
    public static final BlockDefinition<QuartzPillarBlock> QUARTZ_PILLAR = AEBlocks.block("Certus Quartz Pillar", AEBlockIds.QUARTZ_PILLAR, () -> new QuartzPillarBlock(QUARTZ_PROPERTIES));
    public static final BlockDefinition<AEDecorativeBlock> CHISELED_QUARTZ_BLOCK = AEBlocks.block("Chiseled Certus Quartz Block", AEBlockIds.CHISELED_QUARTZ_BLOCK, () -> new AEDecorativeBlock(QUARTZ_PROPERTIES));
    public static final BlockDefinition<QuartzGlassBlock> QUARTZ_GLASS = AEBlocks.block("Quartz Glass", AEBlockIds.QUARTZ_GLASS, () -> new QuartzGlassBlock(AEBaseBlock.defaultProps(Material.f_76275_).m_60955_().m_60922_(NEVER_ALLOW_SPAWN)));
    public static final BlockDefinition<QuartzLampBlock> QUARTZ_VIBRANT_GLASS = AEBlocks.block("Vibrant Quartz Glass", AEBlockIds.QUARTZ_VIBRANT_GLASS, () -> new QuartzLampBlock(AEBaseBlock.defaultProps(Material.f_76275_).m_60953_(b -> 15).m_60955_().m_60922_(NEVER_ALLOW_SPAWN)));
    public static final BlockDefinition<QuartzFixtureBlock> QUARTZ_FIXTURE = AEBlocks.block("Charged Quartz Fixture", AEBlockIds.QUARTZ_FIXTURE, QuartzFixtureBlock::new);
    public static final BlockDefinition<AEDecorativeBlock> FLUIX_BLOCK = AEBlocks.block("Fluix Block", AEBlockIds.FLUIX_BLOCK, () -> new AEDecorativeBlock(QUARTZ_PROPERTIES));
    public static final BlockDefinition<SkyStoneBlock> SKY_STONE_BLOCK = AEBlocks.block("Sky Stone", AEBlockIds.SKY_STONE_BLOCK, () -> new SkyStoneBlock(SkyStoneBlock.SkystoneType.STONE, AEBaseBlock.defaultProps(Material.f_76278_).m_60913_(50.0f, 150.0f).m_60999_()));
    public static final BlockDefinition<SkyStoneBlock> SMOOTH_SKY_STONE_BLOCK = AEBlocks.block("Sky Stone Block", AEBlockIds.SMOOTH_SKY_STONE_BLOCK, () -> new SkyStoneBlock(SkyStoneBlock.SkystoneType.BLOCK, SKYSTONE_PROPERTIES));
    public static final BlockDefinition<SkyStoneBlock> SKY_STONE_BRICK = AEBlocks.block("Sky Stone Brick", AEBlockIds.SKY_STONE_BRICK, () -> new SkyStoneBlock(SkyStoneBlock.SkystoneType.BRICK, SKYSTONE_PROPERTIES));
    public static final BlockDefinition<SkyStoneBlock> SKY_STONE_SMALL_BRICK = AEBlocks.block("Sky Stone Small Brick", AEBlockIds.SKY_STONE_SMALL_BRICK, () -> new SkyStoneBlock(SkyStoneBlock.SkystoneType.SMALL_BRICK, SKYSTONE_PROPERTIES));
    public static final BlockDefinition<SkyChestBlock> SKY_STONE_CHEST = AEBlocks.block("Sky Stone Chest", AEBlockIds.SKY_STONE_CHEST, () -> new SkyChestBlock(SkyChestBlock.SkyChestType.STONE, SKY_STONE_CHEST_PROPS));
    public static final BlockDefinition<SkyChestBlock> SMOOTH_SKY_STONE_CHEST = AEBlocks.block("Sky Stone Block Chest", AEBlockIds.SMOOTH_SKY_STONE_CHEST, () -> new SkyChestBlock(SkyChestBlock.SkyChestType.BLOCK, SKY_STONE_CHEST_PROPS));
    public static final BlockDefinition<SkyStoneTankBlock> SKY_STONE_TANK = AEBlocks.block("Sky Stone Tank", AEBlockIds.SKY_STONE_TANK, () -> new SkyStoneTankBlock(SKY_STONE_CHEST_PROPS));
    public static final BlockDefinition<SkyCompassBlock> SKY_COMPASS = AEBlocks.block("Meteorite Compass", AEBlockIds.SKY_COMPASS, () -> new SkyCompassBlock(AEBaseBlock.defaultProps(Material.f_76310_)));
    public static final BlockDefinition<InscriberBlock> INSCRIBER = AEBlocks.block("Inscriber", AEBlockIds.INSCRIBER, () -> new InscriberBlock(AEBaseBlock.defaultProps(Material.f_76279_).m_60955_()));
    public static final BlockDefinition<WirelessBlock> WIRELESS_ACCESS_POINT = AEBlocks.block("ME Wireless Access Point", AEBlockIds.WIRELESS_ACCESS_POINT, WirelessBlock::new);
    public static final BlockDefinition<ChargerBlock> CHARGER = AEBlocks.block("Charger", AEBlockIds.CHARGER, ChargerBlock::new);
    public static final BlockDefinition<TinyTNTBlock> TINY_TNT = AEBlocks.block("Tiny TNT", AEBlockIds.TINY_TNT, () -> new TinyTNTBlock(AEBaseBlock.defaultProps(Material.f_76273_).m_60918_(SoundType.f_56739_).m_60978_(0.0f).m_60955_()));
    public static final BlockDefinition<SecurityStationBlock> SECURITY_STATION = AEBlocks.block("ME Security Terminal", AEBlockIds.SECURITY_STATION, SecurityStationBlock::new);
    public static final BlockDefinition<QuantumRingBlock> QUANTUM_RING = AEBlocks.block("ME Quantum Ring", AEBlockIds.QUANTUM_RING, QuantumRingBlock::new);
    public static final BlockDefinition<QuantumLinkChamberBlock> QUANTUM_LINK = AEBlocks.block("ME Quantum Link Chamber", AEBlockIds.QUANTUM_LINK, QuantumLinkChamberBlock::new);
    public static final BlockDefinition<SpatialPylonBlock> SPATIAL_PYLON = AEBlocks.block("Spatial Pylon", AEBlockIds.SPATIAL_PYLON, SpatialPylonBlock::new);
    public static final BlockDefinition<SpatialIOPortBlock> SPATIAL_IO_PORT = AEBlocks.block("Spatial IO Port", AEBlockIds.SPATIAL_IO_PORT, SpatialIOPortBlock::new);
    public static final BlockDefinition<ControllerBlock> CONTROLLER = AEBlocks.block("ME Controller", AEBlockIds.CONTROLLER, ControllerBlock::new);
    public static final BlockDefinition<DriveBlock> DRIVE = AEBlocks.block("ME Drive", AEBlockIds.DRIVE, DriveBlock::new);
    public static final BlockDefinition<ChestBlock> CHEST = AEBlocks.block("ME Chest", AEBlockIds.CHEST, ChestBlock::new);
    public static final BlockDefinition<InterfaceBlock> INTERFACE = AEBlocks.block("ME Interface", AEBlockIds.INTERFACE, InterfaceBlock::new);
    public static final BlockDefinition<CellWorkbenchBlock> CELL_WORKBENCH = AEBlocks.block("Cell Workbench", AEBlockIds.CELL_WORKBENCH, CellWorkbenchBlock::new);
    public static final BlockDefinition<IOPortBlock> IO_PORT = AEBlocks.block("ME IO Port", AEBlockIds.IO_PORT, IOPortBlock::new);
    public static final BlockDefinition<CondenserBlock> CONDENSER = AEBlocks.block("Matter Condenser", AEBlockIds.CONDENSER, CondenserBlock::new);
    public static final BlockDefinition<EnergyAcceptorBlock> ENERGY_ACCEPTOR = AEBlocks.block("Energy Acceptor", AEBlockIds.ENERGY_ACCEPTOR, EnergyAcceptorBlock::new);
    public static final BlockDefinition<VibrationChamberBlock> VIBRATION_CHAMBER = AEBlocks.block("Vibration Chamber", AEBlockIds.VIBRATION_CHAMBER, VibrationChamberBlock::new);
    public static final BlockDefinition<QuartzGrowthAcceleratorBlock> QUARTZ_GROWTH_ACCELERATOR = AEBlocks.block("Crystal Growth Accelerator", AEBlockIds.QUARTZ_GROWTH_ACCELERATOR, QuartzGrowthAcceleratorBlock::new);
    public static final BlockDefinition<EnergyCellBlock> ENERGY_CELL = AEBlocks.block("Energy Cell", AEBlockIds.ENERGY_CELL, EnergyCellBlock::new, AEBaseBlockItemChargeable::new);
    public static final BlockDefinition<DenseEnergyCellBlock> DENSE_ENERGY_CELL = AEBlocks.block("Dense Energy Cell", AEBlockIds.DENSE_ENERGY_CELL, DenseEnergyCellBlock::new, AEBaseBlockItemChargeable::new);
    public static final BlockDefinition<CreativeEnergyCellBlock> CREATIVE_ENERGY_CELL = AEBlocks.block("Creative Energy Cell", AEBlockIds.CREATIVE_ENERGY_CELL, CreativeEnergyCellBlock::new);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_UNIT = AEBlocks.block("Crafting Unit", AEBlockIds.CRAFTING_UNIT, () -> new CraftingUnitBlock(AEBaseBlock.defaultProps(Material.f_76279_), CraftingUnitType.UNIT));
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_ACCELERATOR = AEBlocks.craftingBlock("Crafting Co-Processing Unit", AEBlockIds.CRAFTING_ACCELERATOR, () -> new CraftingUnitBlock(AEBaseBlock.defaultProps(Material.f_76279_), CraftingUnitType.ACCELERATOR), () -> AEItems.ENGINEERING_PROCESSOR);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_1K = AEBlocks.craftingBlock("1k Crafting Storage", AEBlockIds.CRAFTING_STORAGE_1K, () -> new CraftingUnitBlock(AEBaseBlock.defaultProps(Material.f_76279_), CraftingUnitType.STORAGE_1K), () -> AEItems.CELL_COMPONENT_1K);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_4K = AEBlocks.craftingBlock("4k Crafting Storage", AEBlockIds.CRAFTING_STORAGE_4K, () -> new CraftingUnitBlock(AEBaseBlock.defaultProps(Material.f_76279_), CraftingUnitType.STORAGE_4K), () -> AEItems.CELL_COMPONENT_4K);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_16K = AEBlocks.craftingBlock("16k Crafting Storage", AEBlockIds.CRAFTING_STORAGE_16K, () -> new CraftingUnitBlock(AEBaseBlock.defaultProps(Material.f_76279_), CraftingUnitType.STORAGE_16K), () -> AEItems.CELL_COMPONENT_16K);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_64K = AEBlocks.craftingBlock("64k Crafting Storage", AEBlockIds.CRAFTING_STORAGE_64K, () -> new CraftingUnitBlock(AEBaseBlock.defaultProps(Material.f_76279_), CraftingUnitType.STORAGE_64K), () -> AEItems.CELL_COMPONENT_64K);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_256K = AEBlocks.craftingBlock("256k Crafting Storage", AEBlockIds.CRAFTING_STORAGE_256K, () -> new CraftingUnitBlock(AEBaseBlock.defaultProps(Material.f_76279_), CraftingUnitType.STORAGE_256K), () -> AEItems.CELL_COMPONENT_256K);
    public static final BlockDefinition<CraftingMonitorBlock> CRAFTING_MONITOR = AEBlocks.craftingBlock("Crafting Monitor", AEBlockIds.CRAFTING_MONITOR, () -> new CraftingMonitorBlock(AEBaseBlock.defaultProps(Material.f_76279_), CraftingUnitType.MONITOR), () -> AEParts.STORAGE_MONITOR);
    public static final BlockDefinition<PatternProviderBlock> PATTERN_PROVIDER = AEBlocks.block("ME Pattern Provider", AEBlockIds.PATTERN_PROVIDER, PatternProviderBlock::new);
    public static final BlockDefinition<MolecularAssemblerBlock> MOLECULAR_ASSEMBLER = AEBlocks.block("Molecular Assembler", AEBlockIds.MOLECULAR_ASSEMBLER, () -> new MolecularAssemblerBlock(AEBaseBlock.defaultProps(Material.f_76279_).m_60955_()));
    public static final BlockDefinition<LightDetectorBlock> LIGHT_DETECTOR = AEBlocks.block("Light Detecting Fixture", AEBlockIds.LIGHT_DETECTOR, LightDetectorBlock::new);
    public static final BlockDefinition<PaintSplotchesBlock> PAINT = AEBlocks.block("Paint", AEBlockIds.PAINT, PaintSplotchesBlock::new);
    public static final BlockDefinition<StairBlock> SKY_STONE_STAIRS = AEBlocks.block("Sky Stone Stairs", AEBlockIds.SKY_STONE_STAIRS, () -> new StairBlock(() -> ((SkyStoneBlock)SKY_STONE_BLOCK.block()).m_49966_(), SKYSTONE_PROPERTIES));
    public static final BlockDefinition<StairBlock> SMOOTH_SKY_STONE_STAIRS = AEBlocks.block("Sky Stone Block Stairs", AEBlockIds.SMOOTH_SKY_STONE_STAIRS, () -> new StairBlock(() -> ((SkyStoneBlock)SMOOTH_SKY_STONE_BLOCK.block()).m_49966_(), SKYSTONE_PROPERTIES));
    public static final BlockDefinition<StairBlock> SKY_STONE_BRICK_STAIRS = AEBlocks.block("Sky Stone Brick Stairs", AEBlockIds.SKY_STONE_BRICK_STAIRS, () -> new StairBlock(() -> ((SkyStoneBlock)SKY_STONE_BRICK.block()).m_49966_(), SKYSTONE_PROPERTIES));
    public static final BlockDefinition<StairBlock> SKY_STONE_SMALL_BRICK_STAIRS = AEBlocks.block("Sky Stone Small Brick Stairs", AEBlockIds.SKY_STONE_SMALL_BRICK_STAIRS, () -> new StairBlock(() -> ((SkyStoneBlock)SKY_STONE_SMALL_BRICK.block()).m_49966_(), SKYSTONE_PROPERTIES));
    public static final BlockDefinition<StairBlock> FLUIX_STAIRS = AEBlocks.block("Fluix Stairs", AEBlockIds.FLUIX_STAIRS, () -> new StairBlock(() -> ((AEDecorativeBlock)FLUIX_BLOCK.block()).m_49966_(), QUARTZ_PROPERTIES));
    public static final BlockDefinition<StairBlock> QUARTZ_STAIRS = AEBlocks.block("Certus Quartz Stairs", AEBlockIds.QUARTZ_STAIRS, () -> new StairBlock(() -> ((AEDecorativeBlock)QUARTZ_BLOCK.block()).m_49966_(), QUARTZ_PROPERTIES));
    public static final BlockDefinition<StairBlock> CHISELED_QUARTZ_STAIRS = AEBlocks.block("Chiseled Certus Quartz Stairs", AEBlockIds.CHISELED_QUARTZ_STAIRS, () -> new StairBlock(() -> ((AEDecorativeBlock)CHISELED_QUARTZ_BLOCK.block()).m_49966_(), QUARTZ_PROPERTIES));
    public static final BlockDefinition<StairBlock> QUARTZ_PILLAR_STAIRS = AEBlocks.block("Certus Quartz Pillar Stairs", AEBlockIds.QUARTZ_PILLAR_STAIRS, () -> new StairBlock(() -> ((QuartzPillarBlock)QUARTZ_PILLAR.block()).m_49966_(), QUARTZ_PROPERTIES));
    public static final BlockDefinition<WallBlock> SKY_STONE_WALL = AEBlocks.block("Sky Stone Wall", AEBlockIds.SKY_STONE_WALL, () -> new WallBlock(SKYSTONE_PROPERTIES));
    public static final BlockDefinition<WallBlock> SMOOTH_SKY_STONE_WALL = AEBlocks.block("Sky Stone Block Wall", AEBlockIds.SMOOTH_SKY_STONE_WALL, () -> new WallBlock(SKYSTONE_PROPERTIES));
    public static final BlockDefinition<WallBlock> SKY_STONE_BRICK_WALL = AEBlocks.block("Sky Stone Brick Wall", AEBlockIds.SKY_STONE_BRICK_WALL, () -> new WallBlock(SKYSTONE_PROPERTIES));
    public static final BlockDefinition<WallBlock> SKY_STONE_SMALL_BRICK_WALL = AEBlocks.block("Sky Stone Small Brick Wall", AEBlockIds.SKY_STONE_SMALL_BRICK_WALL, () -> new WallBlock(SKYSTONE_PROPERTIES));
    public static final BlockDefinition<WallBlock> FLUIX_WALL = AEBlocks.block("Fluix Wall", AEBlockIds.FLUIX_WALL, () -> new WallBlock(QUARTZ_PROPERTIES));
    public static final BlockDefinition<WallBlock> QUARTZ_WALL = AEBlocks.block("Certus Quartz Wall", AEBlockIds.QUARTZ_WALL, () -> new WallBlock(QUARTZ_PROPERTIES));
    public static final BlockDefinition<WallBlock> CHISELED_QUARTZ_WALL = AEBlocks.block("Chiseled Certus Quartz Wall", AEBlockIds.CHISELED_QUARTZ_WALL, () -> new WallBlock(QUARTZ_PROPERTIES));
    public static final BlockDefinition<WallBlock> QUARTZ_PILLAR_WALL = AEBlocks.block("Certus Quartz Pillar Wall", AEBlockIds.QUARTZ_PILLAR_WALL, () -> new WallBlock(QUARTZ_PROPERTIES));
    public static final BlockDefinition<CableBusBlock> CABLE_BUS = AEBlocks.block("AE2 Cable and/or Bus", AEBlockIds.CABLE_BUS, CableBusBlock::new);
    public static final BlockDefinition<SlabBlock> SKY_STONE_SLAB = AEBlocks.block("Sky Stone Slabs", AEBlockIds.SKY_STONE_SLAB, () -> new SlabBlock(SKYSTONE_PROPERTIES));
    public static final BlockDefinition<SlabBlock> SMOOTH_SKY_STONE_SLAB = AEBlocks.block("Sky Stone Block Slabs", AEBlockIds.SMOOTH_SKY_STONE_SLAB, () -> new SlabBlock(SKYSTONE_PROPERTIES));
    public static final BlockDefinition<SlabBlock> SKY_STONE_BRICK_SLAB = AEBlocks.block("Sky Stone Brick Slabs", AEBlockIds.SKY_STONE_BRICK_SLAB, () -> new SlabBlock(SKYSTONE_PROPERTIES));
    public static final BlockDefinition<SlabBlock> SKY_STONE_SMALL_BRICK_SLAB = AEBlocks.block("Sky Stone Small Brick Slabs", AEBlockIds.SKY_STONE_SMALL_BRICK_SLAB, () -> new SlabBlock(SKYSTONE_PROPERTIES));
    public static final BlockDefinition<SlabBlock> FLUIX_SLAB = AEBlocks.block("Fluix Slabs", AEBlockIds.FLUIX_SLAB, () -> new SlabBlock(QUARTZ_PROPERTIES));
    public static final BlockDefinition<SlabBlock> QUARTZ_SLAB = AEBlocks.block("Certus Quartz Slabs", AEBlockIds.QUARTZ_SLAB, () -> new SlabBlock(QUARTZ_PROPERTIES));
    public static final BlockDefinition<SlabBlock> CHISELED_QUARTZ_SLAB = AEBlocks.block("Chiseled Certus Quartz Slabs", AEBlockIds.CHISELED_QUARTZ_SLAB, () -> new SlabBlock(QUARTZ_PROPERTIES));
    public static final BlockDefinition<SlabBlock> QUARTZ_PILLAR_SLAB = AEBlocks.block("Certus Quartz Pillar Slabs", AEBlockIds.QUARTZ_PILLAR_SLAB, () -> new SlabBlock(QUARTZ_PROPERTIES));
    public static final BlockDefinition<SpatialAnchorBlock> SPATIAL_ANCHOR = AEBlocks.block("Spatial Anchor", AEBlockIds.SPATIAL_ANCHOR, SpatialAnchorBlock::new);
    public static final BlockDefinition<ItemGenBlock> DEBUG_ITEM_GEN = AEBlocks.block("Dev.ItemGen", AppEng.makeId("debug_item_gen"), ItemGenBlock::new);
    public static final BlockDefinition<ChunkLoaderBlock> DEBUG_CHUNK_LOADER = AEBlocks.block("Dev.ChunkLoader", AppEng.makeId("debug_chunk_loader"), ChunkLoaderBlock::new);
    public static final BlockDefinition<PhantomNodeBlock> DEBUG_PHANTOM_NODE = AEBlocks.block("Dev.PhantomNode", AppEng.makeId("debug_phantom_node"), PhantomNodeBlock::new);
    public static final BlockDefinition<CubeGeneratorBlock> DEBUG_CUBE_GEN = AEBlocks.block("Dev.CubeGen", AppEng.makeId("debug_cube_gen"), CubeGeneratorBlock::new);
    public static final BlockDefinition<EnergyGeneratorBlock> DEBUG_ENERGY_GEN = AEBlocks.block("Dev.EnergyGen", AppEng.makeId("debug_energy_gen"), EnergyGeneratorBlock::new);

    private static <T extends Block> BlockDefinition<T> craftingBlock(String englishName, ResourceLocation id, Supplier<T> blockSupplier, Supplier<ItemLike> disassemblyExtra) {
        return AEBlocks.block(englishName, id, blockSupplier, (block, props) -> new CraftingBlockItem((Block)block, (Item.Properties)props, disassemblyExtra));
    }

    public static List<BlockDefinition<?>> getBlocks() {
        return Collections.unmodifiableList(BLOCKS);
    }

    private static <T extends Block> BlockDefinition<T> block(String englishName, ResourceLocation id, Supplier<T> blockSupplier) {
        return AEBlocks.block(englishName, id, blockSupplier, null);
    }

    private static <T extends Block> BlockDefinition<T> block(String englishName, ResourceLocation id, Supplier<T> blockSupplier, @Nullable BiFunction<Block, Item.Properties, BlockItem> itemFactory) {
        BlockItem item;
        Block block = (Block)blockSupplier.get();
        Item.Properties itemProperties = new Item.Properties();
        itemProperties.m_41491_(CreativeTab.INSTANCE);
        if (itemFactory != null) {
            item = itemFactory.apply(block, itemProperties);
            if (item == null) {
                throw new IllegalArgumentException("BlockItem factory for " + id + " returned null");
            }
        } else {
            item = block instanceof AEBaseBlock ? new AEBaseBlockItem(block, itemProperties) : new BlockItem(block, itemProperties);
        }
        BlockDefinition<Block> definition = new BlockDefinition<Block>(englishName, id, block, item);
        CreativeTab.add(definition);
        BLOCKS.add(definition);
        return definition;
    }

    public static void init() {
    }
}

